#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_IINPUT_SOURCE_CALLBACKS_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_IINPUT_SOURCE_CALLBACKS_H

#include "common.h"

/**
 * This class represents an interface that a sink implementation must subclass if they
 * wish to recieve input feedback events from the MD.
 */
class IInputSourceCallbacks {
public:
    virtual ~IInputSourceCallbacks() { }
    /**
     * @param feedback the feedback event sent by the MD.
     */
    virtual void onInputFeedback(const InputFeedback& feedback) = 0;
};

#endif // ANDROID_AUTO_PROJECTION_PROTOCOL_IINPUT_SOURCE_CALLBACKS_H
